'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Befehl136_Click()
    'Pflichtfeld prfen
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.Enabled = True
        Me.km_TabKuerzel.SetFocus
        Exit Sub
    End If

    'wenn alles Ok, dann Formular schliessen
    DoCmd.Close

End Sub

Private Sub Befehl93_Click()
    Dim stDocName As String
    Dim stLinkCriteria As String
    
    'Pflichtfeld prfen
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.Enabled = True
        Me.km_TabKuerzel.SetFocus
        Exit Sub
    End If

    
    stDocName = "Einstellungen"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
End Sub

Private Sub Button_Bericht_Preise_Click()
    
    Dim strAbfrage As String
    Dim Art As String
    
    
    RePreisJeKalender = Me.Kasten_PreisJeKalenderJaNein.Value
    RePreisJeKategorie = Me.Kasten_PreisJeKategorieJaNein
    
    BerichteUeberschrift = ""
    Art = ""
    
    'Berichtsfilter aufbauen
    BerichteFilter = ""
    If (RePreisJeKalender = True) And (RePreisJeKategorie = True) Then
        'Preise je Kalender UND Kategorie
        BerichteFilter = "([lfd_Nr_Kalender]<>0)"
        BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]<>" & SatzKategorieDummy & ")"
        Art = "Frage"
    Else
        If RePreisJeKalender = True Then
            'Preise nach Kalendern differenziert
            BerichteFilter = "([lfd_Nr_Kalender]<>0)"
            BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
            Art = "KategorieKalender"
            BerichteUeberschrift = "Preise je Kalender"
        ElseIf RePreisJeKategorie = True Then
            'Preise nach Kategorien differenziert
            BerichteFilter = "([lfd_Nr_Kalender]=0)"
            BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]<>" & SatzKategorieDummy & ")"
            Art = "KalenderKategorie"
            BerichteUeberschrift = "Preise je Kategorie"
        Else
            'Keine Diff. nach Kalendern oder Kategorien
            BerichteFilter = "([lfd_Nr_Kalender]=0)"
            BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
            Art = "KalenderKategorie"
            BerichteUeberschrift = "Preise (allgemein)"
        End If
    End If
    BerichteFilter = BerichteFilter & " AND ([lfd_Nr_Kunde]=" & SatzKontaktDummy & ")"
    
    'Wenn Preis je Kalender UND Kategorie: Frage, welche Sortierung gewnscht
    If Art = "Frage" Then
        If MsgBox("Bitte whlen Sie die Sortierung des Berichts:" & vbNewLine & vbNewLine & "[Ja] = Kalender / Kategorien" & vbNewLine & vbNewLine _
            & "[Nein] = Kategorien / Kalender", vbQuestion + vbYesNo + vbDefaultButton1, "Frage...") = vbYes Then
                Art = "KalenderKategorie"
        Else
                Art = "KategorieKalender"
        End If
    End If
    
    
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    'BerichteUeberschrift = ""
    BerichteJahreswahl = ""
    
    
    If Art = "KategorieKalender" Then
        'Preise: Kategorie/Kalender
        'Formular anzeigen
        If BerichteUeberschrift = "" Then BerichteUeberschrift = "Preise (Kategorie/Kalender)"
        'BerichteFilter wird weiter oben abgefragt und gesetzt,
        '  damit die Warte-Meldung die Bentutzereingabe nicht strt
        DoCmd.OpenReport "Preise_KategorieKalender", acPreview
    Else
        'Preise: Kalender/Kategorie
        'Formular anzeigen
        If BerichteUeberschrift = "" Then BerichteUeberschrift = "Preise (Kalender/Kategorie)"
        'BerichteFilter wird weiter oben abgefragt und gesetzt,
        '  damit die Warte-Meldung die Bentutzereingabe nicht strt
        DoCmd.OpenReport "Preise_KalenderKategorie", acPreview
    End If


    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
    'Berichtsvorschau auf ganzes Blatt zoomen
    DoCmd.RunCommand acCmdFitToWindow
    
End Sub

Private Sub Button_Kalender_zusammenfuehren_Click()
On Error GoTo Err_Button_Kalender_zusammenfuehren_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Pflichtfeld prfen
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.Enabled = True
        Me.km_TabKuerzel.SetFocus
        Exit Sub
    End If
    
    

    stDocName = "Kalender_zusammenfuehren"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
    

Exit_Button_Kalender_zusammenfuehren_Click:
    Exit Sub

Err_Button_Kalender_zusammenfuehren_Click:
    MsgBox err.Description
    Resume Exit_Button_Kalender_zusammenfuehren_Click
    
End Sub

Private Sub Button_Kontakteordner_Click()
    OutlookOrdner_Art = "Kontakte"
    Me.Terminordner_Postfach.Visible = False
    Me.Terminordner_Ebene1.Visible = False
    Me.Terminordner_Ebene2.Visible = False
    Me.Terminordner_Ebene3.Visible = False
    Me.Kontaktordner_Postfach.Visible = True
    Me.Kontaktordner_Ebene1.Visible = True
    Me.Kontaktordner_Ebene2.Visible = True
    Me.Kontaktordner_Ebene3.Visible = True
    Me.Button_Terminordner.FontWeight = 400
    Me.Button_Kontakteordner.FontWeight = 700
End Sub

Private Sub Button_Terminordner_Click()
    OutlookOrdner_Art = "Termine"
    Me.Terminordner_Postfach.Visible = True
    Me.Terminordner_Ebene1.Visible = True
    Me.Terminordner_Ebene2.Visible = True
    Me.Terminordner_Ebene3.Visible = True
    Me.Kontaktordner_Postfach.Visible = False
    Me.Kontaktordner_Ebene1.Visible = False
    Me.Kontaktordner_Ebene2.Visible = False
    Me.Kontaktordner_Ebene3.Visible = False
    Me.Button_Terminordner.FontWeight = 700
    Me.Button_Kontakteordner.FontWeight = 400
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub
Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Open(Cancel As Integer)
'    If FormularBereich = "Gebuehren" Then Button_Gebuehren_Click
'    If FormularBereich = "Steuersaetze" Then Button_Steuersaetze_Click
    
    FormularName = "Einstellungen_2"

    Me.Kontaktordner_Postfach.Visible = False
    Me.Kontaktordner_Ebene1.Visible = False
    Me.Kontaktordner_Ebene2.Visible = False
    Me.Kontaktordner_Ebene3.Visible = False
    OutlookOrdner_Art = "Termine"
'    If InStr(VersionProgramm, "(97)") Then
'        Me.OutlookOrdnerlist_anzeigen.Enabled = False
'    Else
'        Me.OutlookOrdnerlist_anzeigen.Enabled = True
'    End If

    'Felder, die nicht bentigt werden, abblenden
    km_JaNein_AfterUpdate
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.Text101.Format = "Currency"
    
    'Kategorieliste fr Preise nach Kategorie auf den ersten Eintrag der Liste einstellen
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien WHERE [Kategorie_ID] <> '0123456789DUMMY9876543210' ORDER BY [Name1]")
    'Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien ORDER BY [Name1]")
    If rst.RecordCount > 0 Then
        rst.MoveLast                'Auffllen
        rst.MoveFirst
        Me.Kategorien_direkt.DefaultValue = rst!lfd_Nr
        Me.Kategorien_direkt.Requery
    End If
    rst.Close
    
    
    'Preisliste entsprechend den gespeicherten Einstellungen eingrenzen:
    Kasten_PreisJeKategorieJaNein_AfterUpdate
    Kasten_PreisJeKalenderJaNein_AfterUpdate
    
    
End Sub

Private Sub Kalender_direkt_AfterUpdate()
    Kalender_direkt_Change
End Sub

Private Sub Kalender_direkt_Change()
    'Filterung der Preisliste auf den eingestellten Wert
    Me.Preise.Form.FilterOn = True
    
    If (IsNull(Me.Kalender_direkt.Value)) Or (Me.Kalender_direkt.Value < 1) Then
        'Wenn Auswahl keinen Wert enthlt, 0 bergeben
        Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kalender]=0)"
        AktKalender = 0
    Else
        Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kalender]=" & Me.Kalender_direkt.Value & ")"
        AktKalender = Me.Kalender_direkt.Value
    End If
    '... und Kategorieeingrenzung:
    If RePreisJeKategorie = False Then
        Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
    Else
        Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
    End If
    
    Me.Preise.Form.Requery
    
End Sub

Private Sub Kasten_PreisJeKalenderJaNein_AfterUpdate()

    Me.Preise.Form.FilterOn = True
    If Me.Kasten_PreisJeKalenderJaNein.Value = False Then
        'Allgemeine Preisliste verwenden
        RePreisJeKalender = False
        Me.Mehrfachwahl_Kal_Bild.Visible = False
        Me.Mehrfachwahl_Kal_Button.Visible = False
        Me.Kalender_direkt.Enabled = False
        'unsichtbar, damit grau angezeigter Wert nicht zu Irritationen fhrt:
        Me.Kalender_direkt.Visible = False
        'Kundeneingrenzung:
        'hier in den Einstellungen immer Preise ohne Kundenbezug
        Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ")"
        'Kategorieeingrenzung:
        If RePreisJeKategorie = False Then
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
        Else
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
        End If
        'Kalendereingrenzung
        Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=0)"
    Else
        'Preisliste je Kalender
        RePreisJeKalender = True
        Me.Kalender_direkt.Visible = True
        Me.Kalender_direkt.Enabled = True
        Me.Mehrfachwahl_Kal_Bild.Visible = True
        Me.Mehrfachwahl_Kal_Button.Visible = True
        'Kalenderliste fr Preise nach Kalender auf den ersten Eintrag der Liste einstellen,
        'da sonst die Kalenderabfrage (dadrunter) beim Formularffnen einen Fehler versursacht!!!
        Set dbs = CurrentDb
        'Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien WHERE [Kategorie_ID] <> '0123456789DUMMY9876543210' ORDER BY [Name1]")
        Set rst = dbs.OpenRecordset("SELECT * FROM Kalender ORDER BY [Name]")
        If rst.RecordCount > 0 Then
            rst.MoveLast                'Auffllen
            rst.MoveFirst
            Me.Kalender_direkt.DefaultValue = rst!lfd_Nr
            Me.Kalender_direkt.Requery
            AktKalender = rst!lfd_Nr
        Else
            AktKalender = 0
        End If
        rst.Close
        
        If AktKalender = 0 Then
            'Wenn Auswahl keinen Wert enthlt, 0 bergeben
            Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kalender]=0)"
        Else
            Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kalender]=" & AktKalender & ")"
        End If
        '... und Kategorieeingrenzung:
        If RePreisJeKategorie = False Then
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
        Else
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
        End If
        
    End If
    Me.Preise.Form.Requery

End Sub

Private Sub Kasten_PreisJeKategorieJaNein_AfterUpdate()
    
    Me.Preise.Form.FilterOn = True
    If Me.Kasten_PreisJeKategorieJaNein.Value = False Then
        'Allgemeine Preisliste verwenden
        RePreisJeKategorie = False
        Me.Mehrfachwahl_Kat_Bild.Visible = False
        Me.Mehrfachwahl_Kat_Button.Visible = False
        Me.Kategorien_direkt.Enabled = False
        'unsichtbar, damit grau angezeigter Wert nicht zu Irritationen fhrt:
        Me.Kategorien_direkt.Visible = False
        'Kundeneingrenzung:
        Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ")"
        'Kategorieeingrenzung:
        Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
        'Kalendereingrenzung:
        If RePreisJeKalender = False Then
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=0)"
        Else
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=" & AktKalender & ")"
        End If
    Else
        'Preisliste je Kategorie
        RePreisJeKategorie = True
        Me.Kategorien_direkt.Visible = True
        Me.Kategorien_direkt.Enabled = True
        Me.Mehrfachwahl_Kat_Bild.Visible = True
        Me.Mehrfachwahl_Kat_Button.Visible = True
        'Kategorieliste fr Preise nach Kategorie auf den ersten Eintrag der Liste einstellen,
        'da sonst die Kategorieabfrage (dadrunter) beim Formularffnen einen Fehler versursacht!!!
        Set dbs = CurrentDb
        Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien WHERE [Kategorie_ID] <> '0123456789DUMMY9876543210' ORDER BY [Name1]")
        'Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien ORDER BY [Name1]")
        If rst.RecordCount > 0 Then
            rst.MoveLast                'Auffllen
            rst.MoveFirst
            Me.Kategorien_direkt.DefaultValue = rst!lfd_Nr
            Me.Kategorien_direkt.Requery
            AktKategorie = rst!lfd_Nr
        Else
            AktKategorie = 0
        End If
        rst.Close
        
        If AktKategorie = 0 Then
            'Wenn Auswahl keinen Wert enthlt, 0 bergeben
            Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kategorie]=0)"
        Else
            Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
        End If
        '... und Kalendereingrenzung:
        If RePreisJeKalender = False Then
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=0)"
        Else
            Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=" & AktKalender & ")"
        End If
        
    End If
    Me.Preise.Form.Requery
    
End Sub

Private Sub Kategorien_direkt_AfterUpdate()
    Kategorien_direkt_Change
End Sub

Private Sub Kategorien_direkt_Change()
    'Filterung der Preisliste auf den eingestellten Wert
    Me.Preise.Form.FilterOn = True
    
    If (IsNull(Me.Kategorien_direkt.Value)) Or (Me.Kategorien_direkt.Value < 1) Then
        'Wenn Auswahl keinen Wert enthlt, 0 bergeben
        Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kategorie]=0)"
        AktKategorie = 0
    Else
        Me.Preise.Form.Filter = "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ") AND ([lfd_Nr_Kategorie]=" & Me.Kategorien_direkt.Value & ")"
        AktKategorie = Me.Kategorien_direkt.Value
    End If
    '... und Kalendereingrenzung:
    If RePreisJeKalender = False Then
        Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=0)"
    Else
        Me.Preise.Form.Filter = Me.Preise.Form.Filter & " AND ([lfd_Nr_Kalender]=" & AktKalender & ")"
    End If
    
    Me.Preise.Form.Requery
    
End Sub

Private Sub km_JaNein_AfterUpdate()
    'Felder, die nicht bentigt werden, abblenden
    If Me.km_JaNein.Value = False Then
        Me.km_Verwendung.Enabled = False
        Me.km_Text.Enabled = False
        Me.km_TabKuerzel.Enabled = False
        Me.km_DezTrenner.Enabled = False
        Me.km_Nachkomma.Enabled = False
        Me.km_Preisliste.Enabled = False
    Else
        Me.km_Verwendung.Enabled = True
        Me.km_Text.Enabled = True
        Me.km_TabKuerzel.Enabled = True
        Me.km_DezTrenner.Enabled = True
        Me.km_Nachkomma.Enabled = True
        Me.km_Preisliste.Enabled = True
    End If
End Sub

Private Sub km_TabKuerzel_LostFocus()
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.SetFocus
    End If
    Me.km_TabKuerzel = Trim(Me.km_TabKuerzel)
End Sub

Private Sub km_Text_Exit(Cancel As Integer)
    Me.km_Text = Trim(Me.km_Text)
End Sub

Private Sub Mehrfachwahl_Kal_Button_Click()
    Dim dbs As Database
    Dim rst As Recordset
    
    Set dbs = CurrentDb
    
    'Prfung, ob mind. 1 Kalender existiert
    Set rst = dbs.OpenRecordset("SELECT * FROM Kalender")
    If rst.RecordCount = 0 Then
        MsgBox "Es sind keine Kalender zur Auswahl vorhanden.", vbInformation + vbOKOnly, "Fehlende Kalender"
        rst.Close
        Exit Sub
    End If
    rst.Close
    
''Deaktiviert, damit die Kalenderpreise fr ALLE Kategorien eingegeben werden knnen
''    'Prfung, ob mind. 1 Kategorie existiert
''    Set rst = dbs.OpenRecordset(("SELECT * FROM Kategorien WHERE lfd_Nr <> " & SatzKategorieDummy))
''    If rst.RecordCount = 0 Then
''        MsgBox "Es sind keine Kategorien zur Auswahl vorhanden.", vbInformation + vbOKOnly, "Fehlende Kategorien"
''        rst.Close
''        Exit Sub
''    End If
''    rst.Close
    
    If Me.Kasten_PreisJeKategorieJaNein.Value = True Then
        'Kalender UND Kategorien
        Mehrfachwahl_Primaer = "Kategorie"
    Else
        'NUR Kalender
        Mehrfachwahl_Primaer = "NurKalender"
    End If
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    DoCmd.OpenForm "Mehrfachwahl_PreisNeu"
End Sub

Private Sub Mehrfachwahl_Kat_Button_Click()
    Dim dbs As Database
    Dim rst As Recordset
    
    Set dbs = CurrentDb
    
    'Prfung, ob mind. 1 Kategorie existiert
    Set rst = dbs.OpenRecordset(("SELECT * FROM Kategorien WHERE lfd_Nr <> " & SatzKategorieDummy))
    If rst.RecordCount = 0 Then
        MsgBox "Es sind keine Kategorien zur Auswahl vorhanden.", vbInformation + vbOKOnly, "Fehlende Kategorien"
        rst.Close
        Exit Sub
    End If
    rst.Close
    
''Deaktiviert, damit die Kategoriepreise fr ALLE Kalender eingegeben werden knnen
''    'Prfung, ob mind. 1 Kalender existiert
''    Set rst = dbs.OpenRecordset("SELECT * FROM Kalender")
''    If rst.RecordCount = 0 Then
''        MsgBox "Es sind keine Kalender zur Auswahl vorhanden.", vbInformation + vbOKOnly, "Fehlende Kalender"
''        rst.Close
''        Exit Sub
''    End If
''    rst.Close
    
    If Me.Kasten_PreisJeKalenderJaNein.Value = True Then
        'Kalender UND Kategorien
        Mehrfachwahl_Primaer = "Kalender"
    Else
        'NUR Kategorien
        Mehrfachwahl_Primaer = "NurKategorien"
    End If
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    DoCmd.OpenForm "Mehrfachwahl_PreisNeu"
End Sub

Private Sub OutlookOrdnerlist_anzeigen_Click()
On Error GoTo Err_OutlookOrdnerlist_anzeigen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    'Variable vorbelegen
    FehlerFormularOeffnen = False

    stDocName = "Outlook_Ordnerliste"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    If FehlerFormularOeffnen Then
        On Error Resume Next
        DoCmd.Close acForm, "Outlook_Ordnerliste", acSaveNo
        DoCmd.Close acForm, "Bitte_warten", acSaveNo
    End If
    

Exit_OutlookOrdnerlist_anzeigen_Click:
    Exit Sub

Err_OutlookOrdnerlist_anzeigen_Click:
    MsgBox err.Description
    Resume Exit_OutlookOrdnerlist_anzeigen_Click
    
End Sub

Private Sub ZuEinstellungen3_Click()
On Error GoTo Err_ZuEinstellungen3_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Pflichtfeld prfen
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.Enabled = True
        Me.km_TabKuerzel.SetFocus
        Exit Sub
    End If
    
    

    stDocName = "Einstellungen_3"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
    

Exit_ZuEinstellungen3_Click:
    Exit Sub

Err_ZuEinstellungen3_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen3_Click
    
End Sub

Private Sub ZuEinstullungen4_Click()
On Error GoTo Err_ZuEinstellungen4_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Pflichtfeld prfen
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.Enabled = True
        Me.km_TabKuerzel.SetFocus
        Exit Sub
    End If
    
    

    stDocName = "Einstellungen_4"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
    

Exit_ZuEinstellungen4_Click:
    Exit Sub

Err_ZuEinstellungen4_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen4_Click
    
End Sub

Private Sub ZuEinstullungen6_Click()
On Error GoTo Err_ZuEinstellungen6_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Pflichtfeld prfen
    If IsNull(Me.km_TabKuerzel) Or Len(Trim(Me.km_TabKuerzel)) = 0 Then
        MsgBox "Das Datenfeld [Krzel/Einheit] darf nicht leer sein.", vbCritical + vbOKOnly, "Fehler"
        Me.km_TabKuerzel.Enabled = True
        Me.km_TabKuerzel.SetFocus
        Exit Sub
    End If
    
    

    stDocName = "Einstellungen_6"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
    

Exit_ZuEinstellungen6_Click:
    Exit Sub

Err_ZuEinstellungen6_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen6_Click

End Sub
